/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.TestSection;
import com.quantumdata.sct.dao.jaxb.TestSections;
import com.quantumdata.sct.dao.jaxb.TestSectionsType;
import com.quantumdata.sct.dao.vo.TestSectionVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;
import java.util.List;

public class TestSectionDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    public void readCallback() throws DAOException {
        try {
            TestSections testSections = (TestSections)this.daoObject;
            int n = testSections.getSectionsLength();
            this.daoCollection.clear();
            for (int i = 0; i < n; ++i) {
                TestSectionsType.TestSection testSection = testSections.getSections(i);
                this.daoCollection.put(testSection.getId(), new Integer(i));
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public Object getUniqueKey(Object object) {
        return this.keygen.generateUniqueKey();
    }

    public void add(IPersistable iPersistable, int n) {
        if (iPersistable instanceof TestSectionVO) {
            try {
                TestSectionsType.TestSection testSection = this.factory.createTestSectionsTypeTestSection();
                this.copyTo(testSection, (TestSectionVO)iPersistable);
                ((TestSection)this.daoObject).getTests().add(n, iPersistable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void add(IPersistable iPersistable) {
        int n = ((TestSections)this.daoObject).getSectionsLength();
        this.add(iPersistable, n);
    }

    public IPersistable[] findByAll() throws Exception {
        TestSectionsType.TestSection[] testSectionArray = ((TestSections)this.daoObject).getSections();
        IPersistable[] iPersistableArray = new IPersistable[testSectionArray.length];
        for (int i = 0; i < testSectionArray.length; ++i) {
            TestSectionsType.TestSection testSection = testSectionArray[i];
            iPersistableArray[i] = this.createPersistable(testSection);
        }
        return iPersistableArray;
    }

    private IPersistable createPersistable(Object object) throws Exception {
        TestSectionVO testSectionVO = new TestSectionVO();
        if (object instanceof TestSection) {
            this.copyFrom((TestSection)object, testSectionVO);
        }
        return testSectionVO;
    }

    private void clear(TestSection testSection) {
        testSection.getTests().clear();
        testSection.setDescription("");
    }

    public void updateObject(IPersistable iPersistable) {
        if (!(iPersistable instanceof TestSectionVO)) {
            return;
        }
        try {
            int n = (Integer)this.daoCollection.get(iPersistable.getId());
            TestSectionsType.TestSection testSection = ((TestSections)this.daoObject).getSections(n);
            this.clear(testSection);
            this.copyTo(testSection, (TestSectionVO)iPersistable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void copyTo(TestSection testSection, TestSectionVO testSectionVO) throws Exception {
        testSection.setDescription(testSectionVO.getName());
        testSection.setId((String)testSectionVO.getId());
        for (String string : testSectionVO) {
            TestSection.TestId testId = this.factory.createTestSectionTestId(string);
            testSection.getTests().add(testId);
        }
    }

    private void copyFrom(TestSection testSection, TestSectionVO testSectionVO) {
        testSectionVO.setId(testSection.getId());
        testSectionVO.setName(testSection.getDescription());
        List list = testSection.getTests();
        for (TestSection.TestId testId : list) {
            String string = testId.getValue();
            testSectionVO.add(string);
        }
    }

    public IPersistable getValueObjectForKey(Object object) {
        TestSectionVO testSectionVO = null;
        if (!this.daoCollection.containsKey(object)) {
            return testSectionVO;
        }
        try {
            int n = (Integer)this.daoCollection.get(object);
            TestSectionsType.TestSection testSection = ((TestSections)this.daoObject).getSections(n);
            TestSectionVO testSectionVO2 = new TestSectionVO();
            this.copyTo(testSection, testSectionVO2);
            testSectionVO = testSectionVO2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return testSectionVO;
    }

    public void removeByPrimaryKey(Object object) {
        if (!this.daoCollection.containsKey(object)) {
            return;
        }
        try {
            int n = (Integer)this.daoCollection.get(object);
            ((TestSections)this.daoObject).setSections(n, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

